%This program is used to compute the whole ATS and its standard error for independent cases
%by using Han and Tsung (2006) method.
%n is the number of subjects
%J is the number of observations for each subject
%L is the total number of time points
%limit is the control limit
%n2 out of n1 is the sampling rate
%delta is the shift size
function [AVATS,STDATS,AVANOS,STDANOS]=ATS_D_adap_rf_quality(n,J,L,limit,n2,n1,delta)
m=textread(['univariate_spc_m_00n',num2str(n),'_J',num2str(J),num2str(L),'.txt']);
mv=textread(['univariate_spc_m_00n',num2str(n),'_J',num2str(J),num2str(L),'var.txt']);
s=sqrt(mv);
N=1000;
z=1+0.3.*([1:L]./L).^0.5;
zz=z+delta*ones(1,L);
% zz=z+delta*(1-exp(-10*[1:L]./L));
ss=sqrt(z.^2);
ats=zeros(100,N);
ANOS=zeros(100,N);
for i=1:100
    l=1;
while (l<=N)
 [temp1,temp2]=ATS_D_adap_rf(m(i,:),s(i,:),zz,ss,limit,n2,n1);
 if temp1<L+1
   ats(i,l)=temp1;
   ANOS(i,l)=temp2;
   l=l+1;
 end
end
end
AVATS=mean(mean(ats'));
STDATS=sqrt(var(mean(ats')))/10;
AVANOS=mean(mean(ANOS'));
STDANOS=sqrt(var(mean(ANOS')))/10;
%MSE=mean((mean(ats')-10).^2);